Module MethodOverride

    Class A
        Public Overridable Sub Message()
            Console.WriteLine("To jest wiadomo z A")
        End Sub
    End Class

    Class B
        Inherits A
        Public NotOverridable Overrides Sub Message()
            Console.WriteLine("To jest wiadomo z B")
        End Sub
    End Class

    Class C
        Inherits A
        'MethodOverride.vb(22): sub 'Message'
        'shadows an overridable method in a base class. To
        'override the base method, this method must be declared
        'Overrides'.
        'Public Sub Message()
        '    Console.WriteLine("To jest wiadomo z C")
        'End Sub
    End Class

    Class D
        Inherits B
        'MethodOverride.vb(33): 'Public Overrides Sub Message()'
        'cannot override 'Public Overrides NotOverridable Sub
        'Message()' because it is declared 'NotOverridable'.
        'Public Overrides Sub Message()
        'Public Sub Message()
        '    Console.WriteLine("To jest wiadomo z D")
        'End Sub
    End Class

    Sub Main()
        Dim a As A = New A()
        Dim b As B = New B()
        Dim ba As A = New B()
        Dim c As C = New C()
        Dim ca As A = New C()
        Dim d As D = New D()
        Dim db As B = New D()
        Console.WriteLine("---- metoda A")
        a.Message()
        Console.WriteLine("---- metoda B")
        b.Message()
        Console.WriteLine("---- B -> A")
        ba.Message()
        Console.WriteLine("---- metoda C")
        c.Message()
        Console.WriteLine("---- C -> A")
        ca.Message()
        Console.WriteLine("---- metoda D")
        d.Message()
        Console.WriteLine("---- D -> B")
        db.Message()
    End Sub

End Module
